/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.mixins.tiles;

import fr.iglee42.evolvedmekanism.tiles.upgrade.TieredStorageUpgradeData;
import java.util.List;
import mekanism.api.providers.IBlockProvider;
import mekanism.common.tile.TileEntityPersonalStorage;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.SecurityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={TileEntityPersonalStorage.class}, remap=false)
public class TileEntityPersonalStorageMixin
extends TileEntityMekanism {
    public TileEntityPersonalStorageMixin(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Nullable
    public IUpgradeData getUpgradeData() {
        if (this.isInventoryEmpty(null)) {
            return new TieredStorageUpgradeData(null, SecurityUtils.get().getOwnerUUID((ICapabilityProvider)this));
        }
        List tileSlots = this.getInventorySlots(null);
        return new TieredStorageUpgradeData(tileSlots, SecurityUtils.get().getOwnerUUID((ICapabilityProvider)this));
    }

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof TieredStorageUpgradeData) {
            TieredStorageUpgradeData data = (TieredStorageUpgradeData)upgradeData;
            if (data.inventory() == null) {
                return;
            }
            if (data.owner() != null) {
                this.setOwnerUUID(data.owner());
            }
            for (int i = 0; i < data.inventory().size(); ++i) {
                this.setStackInSlot(i, data.inventory().get(i).getStack());
            }
        } else {
            super.parseUpgradeData(upgradeData);
        }
    }
}

